#include <iostream>
#include <vector>

using namespace std;

int min_index(vector<int> prodavnice, vector<int> stanovnici){
    int min_index = 0;
    for(int i = 0; i < prodavnice.size(); i ++){
        if(prodavnice[i] == 1){
            min_index = i;
            break;
        }
    }
    for(int i = 0; i < stanovnici.size(); i ++){
        if(stanovnici[i] < stanovnici[min_index] && prodavnice[i] == 1){
            min_index = i;
        }
    }
    return min_index;
}

pair<int, int> trenutno_stanje(vector<int> prodavnice, vector<int> stanovnici){
    pair<int, int> res;
    res.first = 0;
    res.second = 0;

    int n = prodavnice.size();

    for(int i = 0; i < n; i ++){
        if(prodavnice[i] == -1){
            res.second += stanovnici[i];
        }
        else if(prodavnice[i] == 1){
            res.first += stanovnici[i];
        }
        else{
            bool l_flag, r_flag;
            for(int j = 1; j < n; j ++){
                if(i - j >= 0){
                    if(prodavnice[i - j] != 0){
                        l_flag = true;
                    }
                }
                if(i + j < n){
                    if(prodavnice[i + j != 0]){
                        r_flag = true;
                    }
                }
                if(l_flag && r_flag){
                    if(prodavnice[i - j] == prodavnice[i + j]){
                        if(prodavnice[i - j] == 1){
                            res.first += stanovnici[i];
                        }
                        else{
                            res.second += stanovnici[i];
                        }
                    }
                    else{
                        res.first += stanovnici[i] / 2;
                        res.second += stanovnici[i] / 2;
                    }
                }
                else if(l_flag){
                    if(prodavnice[i - j] == 1){
                        res.first += stanovnici[i];
                    }
                    else{
                        res.second += stanovnici[i];
                    }
                }
                else if(r_flag){
                    if(prodavnice[i + j] == 1){
                        res.first += stanovnici[i];
                    }
                    else{
                        res.second += stanovnici[i];
                    }
                }
                if(r_flag || l_flag){
                    break;
                }
            }
        }
    }
    return res;
}

int main()
{

    int n,k;
    cin >> n >> k;

    vector<int> prodavnice(n);

    for(int i = 0; i < n; i ++){
        prodavnice[i] = 0;
    }

    for(int i = 0; i < k; i ++){
        int x;
        cin >> x;
        prodavnice[x - 1] = -1;
    }

    vector<int> stanovnici;

    for(int i = 0; i < n; i ++){
        int x;
        cin >> x;
        stanovnici.push_back(x);
    }

    for(int i = 0; i < n; i ++){
        if(prodavnice[i] == 0){
            prodavnice[i] = 1;
        }
    }

    pair<int, int> res = trenutno_stanje(prodavnice, stanovnici);
    while(res.first > res.second){
        prodavnice[min_index(prodavnice, stanovnici)] = 0;
        res = trenutno_stanje(prodavnice, stanovnici);
    }

    int counter = 0;
    for(int i = 0; i < prodavnice.size(); i ++){
        if(prodavnice[i] == 1){
            counter ++;
        }
    }
    cout << counter;

    return 0;
}